/*
 * Decompiled with CFR 0.152.
 */
package com.webhook.repository;

import com.dto.LoginDto;
import com.google.gson.Gson;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import com.utility.TncJdbc;
import com.webhook.CDCEngineHandler;
import com.webhook.DebeziumConnectorConfig;
import com.webhook.dto.TableHooksDto;
import com.webhook.util.CDCStateHandler;
import com.webhook.util.CDCTables;
import com.webhook.util.CreateCDC;
import com.webhook.util.DeleteCDC;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;

@Component
public class CDCRepository {
    private final DbConnection dbConnection;
    private final DebeziumConnectorConfig config;
    private final CDCEngineHandler cdcHandler;
    private final CDCStateHandler cdcStateHandler;

    public CDCRepository(DbConnection dbConnection, DebeziumConnectorConfig config, CDCEngineHandler cdcHandler, CDCStateHandler cdcStateHandler) {
        this.dbConnection = dbConnection;
        this.config = config;
        this.cdcHandler = cdcHandler;
        this.cdcStateHandler = cdcStateHandler;
    }

    public ResponseEntity<Map<String, Object>> subscribe(String body) {
        LoginDto myLogin = this.dbConnection.setToken();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        ArrayList addedTables = new ArrayList();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        Boolean isSuccess = (Boolean)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> {
            try {
                TableHooksDto[] dtoArray = this.makeDtoArray(body);
                this.cdcHandler.stop();
                for (TableHooksDto dto : dtoArray) {
                    this.checkForErrors(dto, jdbcTemplate);
                    this.insertInDatabase(dto, jdbcTemplate);
                    addedTables.add(CDCTables.getTableFromUser((String)dto.getTablename()));
                    success.add(this.makeMap("Subscribed", dto.getTablename() + "s subscribed to " + dto.getUrl()));
                }
            }
            catch (TncException e) {
                status.setRollbackOnly();
                failure.add(e.getErrorMap());
                return false;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                failure.add(new TncException(TncExceptionMessages.WRONG_JSON_STRUCT).getErrorMap());
                return false;
            }
            return true;
        });
        if (!ConvertStr.nullSafeBool((Boolean)isSuccess)) {
            return ConvertStr.getMapResponseEntity((String)"Subscriptions", failure, Collections.emptyList());
        }
        try {
            new CreateCDC(jdbcTemplate, addedTables).execute();
        }
        catch (Exception e) {
            failure.add(new TncException(TncExceptionMessages.WRONG_JSON_STRUCT).getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Subscriptions", failure, Collections.emptyList());
        }
        this.startDebezium(myLogin);
        return ConvertStr.getMapResponseEntity((String)"Subscriptions", Collections.emptyList(), success);
    }

    private TableHooksDto[] makeDtoArray(String body) throws JSONException {
        JSONObject obj = new JSONObject(body);
        obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
        JSONArray jsonArray = obj.getJSONArray("subscriptions");
        body = jsonArray.toString();
        return (TableHooksDto[])new Gson().fromJson(body, TableHooksDto[].class);
    }

    private void checkForErrors(TableHooksDto dto, TncJdbc jdbcTemplate) throws TncException {
        if (this.isInvalidTable(dto.getTablename())) {
            throw new TncException(TncExceptionMessages.INCORRECT_TABLE);
        }
        if (CDCTables.getTableFromUser((String)dto.getTablename()).tableExists((JdbcTemplate)jdbcTemplate)) {
            throw new TncException(TncExceptionMessages.DUPLICATE_TABLE_NAME);
        }
        if (!this.isURLValid(dto.getUrl())) {
            throw new TncException(TncExceptionMessages.INCORRECT_URL);
        }
    }

    private void insertInDatabase(TableHooksDto dto, TncJdbc jdbc) throws TncException {
        CDCTables table = CDCTables.getTableFromUser((String)dto.getTablename());
        table.subscribe(dto, jdbc);
    }

    public ResponseEntity<Map<String, Object>> delete(String param) {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList success = new ArrayList();
        ArrayList disablingTables = new ArrayList();
        Boolean isSuccess = (Boolean)this.dbConnection.getTransactionTemplate(myLogin).execute(status -> {
            try {
                this.cdcHandler.stop();
                if (!ConvertStr.isNullOrEmpty((String)param) && this.isInvalidTable(param)) {
                    throw new TncException(TncExceptionMessages.INCORRECT_TABLE);
                }
                if (!ConvertStr.isNullOrEmpty((String)param)) {
                    CDCTables t = CDCTables.getTableFromUser((String)param);
                    t.unsubscribe((JdbcTemplate)jdbcTemplate);
                    disablingTables.add(t);
                } else {
                    SqlRowSet rs = jdbcTemplate.queryForRowSet(" SELECT WH_TABLE_NAME FROM WEBHOOK_SUBSCRIPTIONS");
                    while (rs.next()) {
                        CDCTables t;
                        String table = rs.getString("WH_TABLE_NAME");
                        if (table == null || (t = CDCTables.getTable((String)table)).getTableToShow().isEmpty()) continue;
                        disablingTables.add(t);
                    }
                    jdbcTemplate.execute(" DELETE FROM WEBHOOK_SUBSCRIPTIONS");
                }
                for (CDCTables t : disablingTables) {
                    success.add(this.makeMap("Deleted", t.getTableToShow().toUpperCase() + " Was Successfully Removed From WebHook Tables"));
                }
            }
            catch (TncException e) {
                status.setRollbackOnly();
                failure.add(e.getErrorMap());
                return false;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                failure.add(new TncException(TncExceptionMessages.WRONG_JSON_STRUCT).getErrorMap());
                return false;
            }
            return true;
        });
        if (!ConvertStr.nullSafeBool((Boolean)isSuccess)) {
            return ConvertStr.getMapResponseEntity((String)"Subscriptions", failure, Collections.emptyList());
        }
        try {
            new DeleteCDC(jdbcTemplate, disablingTables).execute();
        }
        catch (Exception e) {
            failure.add(new TncException(TncExceptionMessages.DEFAULT_ERROR).getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Subscriptions", failure, Collections.emptyList());
        }
        return ConvertStr.getMapResponseEntity((String)"Subscriptions", Collections.emptyList(), success);
    }

    public ResponseEntity<?> getSubs() {
        LoginDto myLogin = this.dbConnection.setToken();
        TncJdbc jdbcTemplate = this.dbConnection.getJdbcTemplate(myLogin);
        ArrayList success = new ArrayList();
        List list = jdbcTemplate.queryForList(" SELECT [API_URL] [url], [WH_TABLE_NAME] [tableName] FROM WEBHOOK_SUBSCRIPTIONS");
        for (Map m : list) {
            HashMap map = new HashMap();
            map.put("url", m.get("url"));
            map.put("table", CDCTables.getTable((String)((String)m.get("tableName"))));
            success.add(map);
        }
        return ConvertStr.getMapResponseEntity((String)"Subscriptions", success, (boolean)false);
    }

    private void startDebezium(LoginDto loginDto) {
        try {
            this.cdcStateHandler.setStartState(loginDto);
            this.cdcHandler.restartConnector(loginDto);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ResponseEntity<Map<String, Object>> startCDC() {
        LoginDto login = this.dbConnection.setToken();
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList<Map> success = new ArrayList<Map>();
        try {
            if (this.config.noTablesSubscribed(login)) {
                throw new TncException(TncExceptionMessages.NO_WEB_HOOKS_SUBSCRIBED);
            }
        }
        catch (TncException e) {
            failure.add(e.getErrorMap());
            return ConvertStr.getMapResponseEntity((String)"Start", failure, success);
        }
        this.startDebezium(login);
        success.add(this.makeMap("Start", "WebHook Started Successfully!"));
        return ConvertStr.getMapResponseEntity((String)"Start", failure, success);
    }

    public ResponseEntity<Map<String, Object>> stopCDC() {
        ArrayList<Map> failure = new ArrayList<Map>();
        ArrayList<Map> success = new ArrayList<Map>();
        try {
            this.cdcHandler.stop();
            this.cdcStateHandler.setStopState();
            success.add(this.makeMap("Stop", "WebHook Stopped Successfully!"));
        }
        catch (IOException e) {
            failure.add(this.makeMap("Failed", "WebHook Stop Failed!"));
            return ConvertStr.getMapResponseEntity((String)"Start", failure, success);
        }
        return ConvertStr.getMapResponseEntity((String)"Stop", failure, success);
    }

    private Map<String, Object> makeMap(String title, String message) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(title, message);
        return model;
    }

    private boolean isURLValid(String url) {
        try {
            URL mURL = new URL(url);
            mURL.toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }

    private boolean isInvalidTable(String tableName) {
        return CDCTables.getTableFromUser((String)tableName).getValue().equals("");
    }
}

